// IBFlowView.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "IBFlowView.h"
#include "InteractionToolView.h"
#include "XISLDialogTag.h"
#include "XISLCombExchangeTag.h"
#include "XISLTouchInputTag.h"
#include "XISLSpeechInputTag.h"
#include "XISLOutputBrowser.h"
#include "XISLOutputFSM.h"
#include "XISLOutputTTS.h"
#include "XISLCallTag.h"
#include "XISLReturnTag.h"
#include "XISLGotoTag.h"
#include "XISLCombInputTag.h"
#include "XISLSwitchTag.h"
#include "XISLCaseTag.h"
#include "XISLIfTag.h"
#include "XISLIfChildTag.h"
#include "XISLAssignTag.h"
#include "XISLPrompt.h"
#include "IBOleDropSource.h"

#include "XISLDialogDlg.h"
#include "XISLExchangeDlg.h"
#include "XISLCallDlg.h"
#include "XISLReturnDlg.h"
#include "XISLSwitchDlg.h"
#include "XISLIFDlg.h"
#include "XISLExitTag.h"
#include "XISLAssignDlg.h"
#include "SpeechInputDlg.h"
#include "TouchInputDlg.h"
#include "OutputTTSDlg.h"
#include "SpeechInputDlg.h"
#include "TouchInputDlg.h"
#include "XISLHeadDlg.h"
#include "MMIBrowserOutputDlg.h"
#include "FSMOutputDlg.h"
#include "ReCallListDlg.h"
#include "XISLPromptDlg.h"

#include "XISLChildFrame.h"
//#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CStatusBar *g_pStBar;
extern CDialogBar *g_pModBar;
extern CDialogBar *g_pTagBar;
extern CInteractionToolView *pIToolView;
extern CIBFlowView *g_pOprTargetView;
/////////////////////////////////////////////////////////////////////////////
// CIBFlowView

IMPLEMENT_DYNCREATE(CIBFlowView, CScrollView)

CIBFlowView::CIBFlowView()
{
	m_pSelectTag = NULL;
	m_pDrawingTag = NULL;
	m_pHighlightTag = NULL;
	m_pTargetTag = NULL;

	m_pHeadDlg = NULL;
	m_pMODlg = NULL;
	m_pTIDlg = NULL;

	m_nSelectBarCtrl = 0;
	m_bAppRoot = FALSE;
	m_bDropOK = TRUE;
	m_XislFileCont=0;
}

CIBFlowView::~CIBFlowView()
{
	m_pSelectTag = NULL;
	m_pDrawingTag = NULL;
	m_pHighlightTag = NULL;
	m_pTargetTag = NULL;
/*	if(m_pFODlg)
		m_pFODlg->DestroyWindow();
	if(m_pMODlg)
		m_pMODlg->DestroyWindow();
	if(m_pAODlg)
		m_pAODlg->DestroyWindow();
	if(m_pSIDlg)
		m_pSIDlg->DestroyWindow();
	if(m_pTIDlg)
		m_pTIDlg->DestroyWindow();
	if(m_pHeadDlg)
		m_pHeadDlg->DestroyWindow();
*/
}


BEGIN_MESSAGE_MAP(CIBFlowView, CScrollView)
	//{{AFX_MSG_MAP(CIBFlowView)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(IDM_XISL_HEAD, OnXislHead)
	ON_WM_RBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_COMMAND(IDM_TAG_PROPERTY, OnTagProperty)
	ON_UPDATE_COMMAND_UI(IDM_TAG_PROPERTY, OnUpdateTagProperty)
	ON_COMMAND(IDM_TAG_GO_PARENT, OnTagGoParent)
	ON_UPDATE_COMMAND_UI(IDM_TAG_GO_PARENT, OnUpdateTagGoParent)
	ON_COMMAND(IDM_TAG_GO_CHILD, OnTagGoChild)
	ON_UPDATE_COMMAND_UI(IDM_TAG_GO_CHILD, OnUpdateTagGoChild)
	ON_COMMAND(IDM_TEST_SELECTEDITEM, OnTestSelecteditem)
	ON_COMMAND(IDM_TAG_DELETE, OnTagDelete)
	ON_UPDATE_COMMAND_UI(IDM_TAG_DELETE, OnUpdateTagDelete)
	ON_COMMAND(IDM_TAB_NEXT_XISL,OnTabGoNextXISL)

	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



//ÕbZ[WM
void CIBFlowView::ReceiveTCPMessage(string &strMessage)
{
//	if(m_pFODlg)
//		m_pFODlg->ReceiveTCPMessage(strMessage);
}

//IEnCCg^Ỏłɍĕ`
void CIBFlowView::ResetViewItem(BOOL bRedraw)
{
	if(m_bDropOK)
	{
		m_pSelectTag = NULL;
		m_pTargetTag = NULL;
		m_pHighlightTag = NULL;
	}
	if(bRedraw)
		InvalidateRect(NULL,FALSE);
}

//XISL^O̍ĕ`
void CIBFlowView::ReDrawXISLTag(CXISLTag *pDrawTag)
{
	m_pDrawingTag = pDrawTag;
	m_pHighlightTag = NULL;
	m_pSelectTag = NULL;
	pIToolView->m_bReDrawView = FALSE;
	pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
	InvalidateRect(NULL);
}

//Dialog^O̒ǉ
void CIBFlowView::XislDialogInsert()
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	if(!pDoc->m_pXISLRoot)
		return;
	

	CXISLDialogTag *pTag = new CXISLDialogTag();
	pTag->m_pParentTag = pDoc->m_pXISLRoot;
	CXISLDialogDlg DialogDlg(pTag,this);
	while(1)
	{
		if(DialogDlg.DoModal() != IDOK)
		{
			delete pTag;
			ResetViewItem();
			return;
		}

		if(pDoc->m_pXISLRoot->InsertDialogTag(pTag))
			break;
	}

	ASSERT(pTag);

	CString strDocName = pDoc->GetTitle();
	pTag->SetDocName(strDocName);

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = pDoc->m_pXISLRoot->m_htreeBody;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_DIALOG];
	tvi.lParam = (LPARAM)pTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	m_pDrawingTag = pTag->m_pParentTag;

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
	return;
}

//Exchange^O̒ǉ
void CIBFlowView::XislExchangeInsert() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ASSERT(m_pTargetTag);

	CXISLExchangeDlg ExcDlg;
	ExcDlg.m_nCombGlp = 1;
	UpdateData(FALSE);
	if(ExcDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLExchangeTag *pExcTag;
	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		pExcTag = ((CXISLDialogTag*)m_pTargetTag)->InsertExchange(ExcDlg.m_nCombGlp,"");
	}
	else if(m_pTargetTag->m_nTagType == ID_TAG_SEXCHANGE
		|| m_pTargetTag->m_nTagType == ID_TAG_PEXCHANGE
		|| m_pTargetTag->m_nTagType == ID_TAG_AEXCHANGE)
	{
		pExcTag = ((CXISLCombExchangeTag*)m_pTargetTag)->InsertExchange(ExcDlg.m_nCombGlp,"");
	}
	else
	{
		AfxMessageBox("ǉł^Odialog***_exchangê݂ł",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		ResetViewItem();
		return ;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();

	HTREEITEM hParent;
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	if(m_pDrawingTag->m_nTagType == ID_TAG_DIALOG)
	{
		CXISLTag *pTag = ((CXISLDialogTag*)m_pDrawingTag)->m_pEnd;
		if(pTag)
			tvs.hInsertAfter = pIToolView->m_treeInteraction.GetPrevSiblingItem(pTag->m_htreeItem);
	}

	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	hParent = m_pTargetTag->m_htreeItem;

	tvi.pszText = XISL_TAG_NAME[ID_TAG_EXCHANGE];
	tvi.lParam = (LPARAM)pExcTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	tvs.hParent = hParent;
	
	hParent = pIToolView->m_treeInteraction.InsertItem(&tvs);
	pExcTag->m_htreeItem = hParent;

	HTREEITEM hItem;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OPERATION];
	tvi.lParam = (LPARAM)pExcTag->m_pXISLOpr;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	tvs.hParent = hParent;

	hItem = pIToolView->m_treeInteraction.InsertItem(&tvs);
	pExcTag->m_pXISLOpr->m_htreeItem = hItem;
	
	tvi.pszText = XISL_TAG_NAME[ID_TAG_ACTION];
	tvi.lParam = (LPARAM)pExcTag->m_pXISLAct;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	tvs.hParent = hParent;

	hItem = pIToolView->m_treeInteraction.InsertItem(&tvs);
	pExcTag->m_pXISLAct->m_htreeItem = hItem;
	
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Prompt^O̒ǉ
//2003/6/6@
void CIBFlowView::XislPromptInsert()
{
	ASSERT(m_pTargetTag);
	if(m_pTargetTag->m_nTagType!=ID_TAG_EXCHANGE)return;
	CXISLPrompt *pPromptTag = new CXISLPrompt(((CXISLExchangeTag *)m_pTargetTag)->m_XISLPromptList.GetCount()+1);
	pPromptTag->m_pParentTag=m_pTargetTag;
	CXISLPromptDlg PDlg(pPromptTag);
	if(PDlg.DoModal() != IDOK)
	{
		delete pPromptTag;
		ResetViewItem();
		return;
	}

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		((CXISLExchangeTag*)m_pTargetTag)->InsertPrompt(pPromptTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_PROMPT];
	tvi.lParam = (LPARAM)pPromptTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pPromptTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Reprompt^O̒ǉ
//2003/6/6@
void CIBFlowView::XislRepromptInsert()
{
	ASSERT(m_pTargetTag);

	CXISLExchangeTag *pExcTag = (CXISLExchangeTag *)m_pTargetTag->GetParentExcTag();
	if(pExcTag->m_XISLPromptList.IsEmpty()!=0){
		MessageBox("<prompt>Ȃƍ쐬ł܂\n<prompt>쐬Ă\n",NULL,MB_OK);
		ResetViewItem(FALSE);
		return;
	}
	CXISLRepromptTag *pRepromptTag = new CXISLRepromptTag(m_pTargetTag);
		
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pRepromptTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pRepromptTag);
		pRepromptTag->m_pParentTag=m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}

	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_REPROMPT];
	tvi.lParam = (LPARAM)pRepromptTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pRepromptTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);

}
//Call^O̒ǉ
void CIBFlowView::XislCallInsert(int nType)
{
	ASSERT(m_pTargetTag);

	CXISLCallTag *pCallTag = new CXISLCallTag(nType);
	CXISLCallDlg CallDlg(pCallTag,m_pTargetTag);

	CallDlg.m_pParentView = this;
	if(CallDlg.DoModal() != IDOK)
	{
		delete pCallTag;
		ResetViewItem();
		return;
	}

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pCallTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pCallTag);
		pCallTag->m_pParentTag=m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pCallTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[nType];
	tvi.lParam = (LPARAM)pCallTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pCallTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislReturnInsert()
{
	ASSERT(m_pTargetTag);
	CXISLReturnTag *pRetTag = new CXISLReturnTag();
	CXISLReturnDlg RetDlg(pRetTag,m_pTargetTag);
//	RetDlg.m_nCount = ((CXISLDialogTag*)m_pDrawingTag->GetParentDialogTag())->GetReCallReturnCount();
	if(RetDlg.m_nCount == -1)
		ASSERT(NULL);
	if(RetDlg.DoModal() != IDOK)
	{
		delete pRetTag;
		ResetViewItem();
		return;
	}

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pRetTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pRetTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pRetTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_RETURN];
	tvi.lParam = (LPARAM)pRetTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pRetTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislSwitchInsert()
{
	ASSERT(m_pTargetTag);
	CXISLSwitchTag *pSWTag = new CXISLSwitchTag();
	pSWTag->m_pParentTag = m_pTargetTag;
	CXISLSwitchDlg SWDlg(pSWTag,m_pTargetTag);
	if(SWDlg.DoModal() != IDOK)
	{
		delete pSWTag;
		ResetViewItem();
		return;
	}

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pSWTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pSWTag);
		pSWTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pSWTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_SWITCH];
	tvi.lParam = (LPARAM)pSWTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pSWTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislIfInsert()
{
	ASSERT(m_pTargetTag);
	CXISLIfTag *pIFTag;
	if(m_pTargetTag->m_nTagType==ID_TAG_IF || m_pTargetTag->m_nTagType==ID_TAG_ELSEIF)
		pIFTag = new CXISLIfTag(ID_TAG_ELSEIF);
	else
		pIFTag = new CXISLIfTag(ID_TAG_IF);
	pIFTag->m_pParentTag = m_pTargetTag;
	CXISLIFDlg IFDlg(pIFTag,m_pTargetTag);
	if(IFDlg.DoModal() != IDOK)
	{
		delete pIFTag;
		ResetViewItem();
		return;
	}

	//c[ɓo^
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pIFTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_THEN || nXISLType == ID_TAG_ELSE)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pIFTag);
		pIFTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_IF || nXISLType ==ID_TAG_ELSEIF){
		((CXISLIfTag*)m_pTargetTag)->AddElseIfTag(pIFTag);
		pIFTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pIFTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_IF];
	tvi.lParam = (LPARAM)pIFTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pIFTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislExitInsert()
{
	ASSERT(m_pTargetTag);

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	CXISLActTag *pActTag;
	CXISLExitTag *pExitTag;
	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		//pExitTag = 
		pExitTag=pActTag->SetExit();
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		//pExitTag = 
		pExitTag=((CXISLActTag*)m_pTargetTag)->SetExit();
		pExitTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		//pExitTag = 
		pExitTag=((CXISLBeginEndTag*)m_pTargetTag)->m_pXISLAct->SetExit();
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_EXIT];
	tvi.lParam = (LPARAM)pExitTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pExitTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislBeginInsert() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ASSERT(m_pTargetTag);

	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		CXISLBeginEndTag *pTag = ((CXISLDialogTag*)m_pTargetTag)->CreateBegin();
		if(!pTag)
		{
			ResetViewItem();
			return;
		}

		CXISLDoc* pDoc = (CXISLDoc*)GetDocument();

		HTREEITEM hParent;
		TVINSERTSTRUCTA tvs;
		TVITEMA tvi;

		tvs.hInsertAfter = TVI_FIRST;
		tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		hParent = m_pTargetTag->m_htreeItem;

		//c[ɓo^
		tvi.pszText = XISL_TAG_NAME[ID_TAG_BEGIN];
		tvi.lParam = (LPARAM)pTag;
		tvi.iImage = 0;
		tvi.iSelectedImage = 1;
		tvs.item = tvi;
		tvs.hParent = hParent;

		hParent = pIToolView->m_treeInteraction.InsertItem(&tvs);
		pTag->m_htreeItem = hParent;
		//m_treeInteraction.SelectItem(m_treeInteraction.InsertItem(&tvs));
		ResetViewItem(FALSE);
		pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);	
		return;
	}
	ASSERT(NULL);
}

void CIBFlowView::XislEndInsert() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ASSERT(m_pTargetTag);

	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		CXISLBeginEndTag *pTag = ((CXISLDialogTag*)m_pTargetTag)->CreateEnd();
		if(!pTag)
		{
			ResetViewItem();
			return;
		}
	
		CXISLDoc* pDoc = (CXISLDoc*)GetDocument();

		HTREEITEM hParent;
		TVINSERTSTRUCTA tvs;
		TVITEMA tvi;

		tvs.hInsertAfter = TVI_LAST;
		tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		hParent = m_pTargetTag->m_htreeItem;

		//c[ɓo^
		tvi.pszText = XISL_TAG_NAME[ID_TAG_END];
		tvi.lParam = (LPARAM)pTag;
		tvi.iImage = 0;
		tvi.iSelectedImage = 1;
		tvs.item = tvi;
		tvs.hParent = hParent;

		hParent = pIToolView->m_treeInteraction.InsertItem(&tvs);
		pTag->m_htreeItem = hParent;
		//m_treeInteraction.SelectItem(m_treeInteraction.InsertItem(&tvs));

		ResetViewItem(FALSE);
		pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);	
		return;
	}
	ASSERT(NULL);
}

//COMB(alt_inputpar_inputȂǂ̋Ǐ)̑}
void CIBFlowView::XislCombInsert(int nCombType)
{
	ASSERT(m_pTargetTag);

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();

	HTREEITEM hParent;
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	int nDTagType = m_pDrawingTag->m_nTagType;
	int nSTagType = m_pTargetTag->m_nTagType;
	hParent = m_pDrawingTag->m_htreeItem;

	BOOL bReplaceFlag = FALSE;

	CXISLTag *pInsertTag = NULL;
	if(nDTagType == ID_TAG_DIALOG)
	{
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_pDrawingTag;
		if(nSTagType == ID_TAG_DIALOG)
			pInsertTag = pDialogTag->InsertCombExchange(nCombType);
		else if(nSTagType == ID_TAG_EXCHANGE ||	nSTagType == ID_TAG_PEXCHANGE
			|| nSTagType == ID_TAG_AEXCHANGE || nSTagType == ID_TAG_SEXCHANGE)
		{
			pInsertTag = pDialogTag->InsertCombExchange(nCombType,m_pTargetTag);
			bReplaceFlag = TRUE;
		}
	}
	else if(nDTagType == ID_TAG_PEXCHANGE || nDTagType == ID_TAG_AEXCHANGE
		|| nDTagType == ID_TAG_SEXCHANGE)
	{
		CXISLCombExchangeTag *pCombExchangeTag = (CXISLCombExchangeTag*)m_pDrawingTag;
		if(m_pTargetTag == m_pDrawingTag)
			pInsertTag = pCombExchangeTag->InsertCombExchange(nCombType);
		else
		{
			pInsertTag = pCombExchangeTag->InsertCombExchange(nCombType,m_pTargetTag);
			bReplaceFlag = TRUE;
		}
	}
	else
	{
		CXISLCombInputTag *pCombTag = new CXISLCombInputTag(m_pDrawingTag,nCombType);
		pInsertTag = pCombTag;
		if(nDTagType == ID_TAG_EXCHANGE)
		{
			hParent = ((CXISLExchangeTag*)m_pDrawingTag)->m_pXISLOpr->m_htreeItem;
			CXISLExchangeTag *pExcTag = (CXISLExchangeTag*)m_pDrawingTag;
			if(nSTagType == ID_TAG_EXCHANGE)
				pExcTag->m_pXISLOpr->InsertOprItem(pCombTag);
			else if(nSTagType == ID_TAG_INPUT || nSTagType == ID_TAG_AINPUT
				|| nSTagType == ID_TAG_SINPUT || nSTagType == ID_TAG_PINPUT)
			{
				pExcTag->m_pXISLOpr->InsertOprItem(pCombTag,m_pTargetTag);
				bReplaceFlag = TRUE;
			}
		}
		else if(nDTagType == ID_TAG_AINPUT || nDTagType == ID_TAG_SINPUT || nDTagType == ID_TAG_PINPUT)
		{
			CXISLCombInputTag *pCombInputTag = (CXISLCombInputTag*)m_pDrawingTag;
			if(m_pTargetTag == m_pDrawingTag){
				pCombInputTag->InsertOprItem(pCombTag);
				//ẽ^OĐݒ
				pCombTag->m_pParentTag = m_pTargetTag;
			}
			else
			{
				pCombInputTag->InsertOprItem(pCombTag,m_pTargetTag);
				bReplaceFlag = TRUE;
			}
		}
		else
		{
			ResetViewItem();
			return;
		}
	}

	if(bReplaceFlag)
	{
		tvs.hInsertAfter = pIToolView->m_treeInteraction.GetPrevSiblingItem(m_pTargetTag->m_htreeItem);
		if(tvs.hInsertAfter == NULL)
			tvs.hInsertAfter = TVI_FIRST;
	}
	else
		tvs.hInsertAfter = TVI_LAST;

	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvi.pszText = XISL_TAG_NAME[pInsertTag->m_nTagType];
	tvi.lParam = (LPARAM)pInsertTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	tvs.hParent = hParent;
	
	hParent = pIToolView->m_treeInteraction.InsertItem(&tvs);
	pInsertTag->m_htreeItem = hParent;

	if(bReplaceFlag)
	{
		HTREEITEM hPastItem = m_pTargetTag->m_htreeItem;
		pIToolView->ReplaceTreeItem(m_pTargetTag->m_htreeItem,hParent);
		pIToolView->m_treeInteraction.DeleteItem(hPastItem);
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::XislAssignInsert()
{
	ASSERT(m_pTargetTag);

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;
	CXISLActTag *pActTag;
	CXISLAssignTag *pAssignTag = new CXISLAssignTag();
	pAssignTag->m_pParentTag = m_pTargetTag;
	CXISLAssignDlg ADlg(pAssignTag,m_pTargetTag);
	if(ADlg.DoModal() != IDOK)
	{
		delete pAssignTag;
		ResetViewItem();
		return;
	}

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);
		
		pActTag->InsertActItem(pAssignTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pAssignTag);
		pAssignTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->m_pXISLAct->InsertActItem(pAssignTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_ASSIGN];
	tvi.lParam = (LPARAM)pAssignTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pAssignTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//̓_eB̑}
void CIBFlowView::InsertInputSpeech() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ASSERT(m_pTargetTag);
	CXISLSpeechInputTag *pInputTag = new CXISLSpeechInputTag;
	int nType = m_pTargetTag->m_nTagType;
	if(nType != ID_TAG_EXCHANGE && nType != ID_TAG_SINPUT
		&& nType != ID_TAG_AINPUT && nType != ID_TAG_PINPUT)
		ASSERT(NULL);
	CSpeechInputDlg SIDlg(pInputTag,m_pTargetTag);

	SIDlg.m_pParent = this;
	if(SIDlg.DoModal() != IDOK)
	{
		delete pInputTag;
		ResetViewItem();
		return;
	}


	CXISLOprTag *pOprTag;

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_FIRST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;

	int nXISLType = m_pTargetTag->m_nTagType;

	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pOprTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLOpr;
		if(pOprTag)
			hParent = pOprTag->m_htreeItem;
		else
			ASSERT(NULL);

		pOprTag->InsertOprItem(pInputTag);
//		pInputTag = ((CXISLExchangeTag*)m_pTargetTag)->InsertInput(ID_INPUTTYPE_SPEECH,"recognize",m_pSIDlg->m_strMatch,m_pSIDlg->m_strNameList);
	}
	else if(nXISLType == ID_TAG_OPERATION)
	{
		((CXISLOprTag*)m_pTargetTag)->InsertOprItem(pInputTag);
//		pInputTag = ((CXISLOprTag*)m_pTargetTag)->CreateInput(ID_INPUTTYPE_SPEECH,"recognize",m_pSIDlg->m_strMatch,m_pSIDlg->m_strNameList);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_SINPUT || nXISLType == ID_TAG_AINPUT || nXISLType == ID_TAG_PINPUT)
	{
		((CXISLCombInputTag*)m_pTargetTag)->InsertOprItem(pInputTag);
		// ẽ^Oݒ(Insert֐ł͐e̐e^OZbgĂ)@2003/5/14ǉ
		pInputTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_INPUT];
	tvi.lParam = (LPARAM)pInputTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pIToolView->m_treeInteraction.InsertItem(&tvs);
	pInputTag->m_htreeItem = hParent;

	m_bDropOK = TRUE;
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::InsertInputTouch() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
//	if(!m_bTI)
//		return;

	ASSERT(m_pTIDlg);
	CXISLOprTag *pOprTag;
	CXISLInputTag *pInputTag = m_pTIDlg->m_pInputTag;
	m_pTargetTag = m_pTIDlg->m_pCurrentTag;
	if(m_pTargetTag == NULL)
	{
		AfxMessageBox("exchange^OIĂ");
		return;
	}

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_FIRST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;

	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE)
	{
		pOprTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLOpr;
		if(pOprTag)
			hParent = pOprTag->m_htreeItem;
		else
			ASSERT(NULL);

		pOprTag->InsertOprItem(pInputTag);
		//->InsertInput(ID_INPUTTYPE_TOUCH,XISL_TOUCH_EVENT[m_pTIDlg->m_nEventGlp],strMatch,strNameList);
	}
	else if(nXISLType == ID_TAG_OPERATION)
	{
		((CXISLOprTag*)m_pTargetTag)->InsertOprItem(pInputTag);
		//->CreateInput(ID_INPUTTYPE_TOUCH,XISL_TOUCH_EVENT[m_pTIDlg->m_nEventGlp],strMatch,strNameList);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_SINPUT || nXISLType == ID_TAG_AINPUT || nXISLType == ID_TAG_PINPUT)
	{
		((CXISLCombInputTag*)m_pTargetTag)->InsertOprItem(pInputTag);
		// ẽ^Oݒ(Insert֐ł͐e̐e^OZbgĂ)@2003/5/14ǉ
		pInputTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);


	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_INPUT];
	tvi.lParam = (LPARAM)pInputTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pInputTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	m_pTIDlg->DestroyWindow();
	m_pTIDlg = NULL;
	m_bDropOK = TRUE;
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::InsertOutputFSM()
{
	ASSERT(m_pTargetTag);

	CXISLOutputFSM *pOutputTag = new CXISLOutputFSM;
	int nType = m_pTargetTag->m_nTagType;

	CFSMOutputDlg OFDlg(pOutputTag,m_pTargetTag);

	OFDlg.m_pParent = this;
//	((CMainFrame*)AfxGetMainWnd())->ConnectIPAEngine(&OFDlg);
	if(OFDlg.DoModal() != IDOK)
	{
		delete pOutputTag;
		ResetViewItem();
		return;
	}

	CXISLActTag *pActTag;
	ASSERT(m_pTargetTag);


	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	int nXISLType = m_pTargetTag->m_nTagType;

	if(nXISLType == ID_TAG_EXCHANGE || nXISLType == ID_TAG_PROMPT)
	{
		if(nXISLType == ID_TAG_EXCHANGE)
			pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		else if(nXISLType == ID_TAG_PROMPT)
			pActTag = ((CXISLPrompt*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pOutputTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem((CXISLActItem*)pOutputTag);
		pOutputTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem((CXISLActItem*)pOutputTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);


	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)pOutputTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pOutputTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	m_bDropOK = TRUE;
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::InsertOutputTTS()
{
	ASSERT(m_pTargetTag);

	CXISLOutputTTS *pOutputTag = new CXISLOutputTTS;
	int nType = m_pTargetTag->m_nTagType;

	COutputTTSDlg OTDlg(pOutputTag,m_pTargetTag);

	OTDlg.m_pParent = this;
//	((CMainFrame*)AfxGetMainWnd())->ConnectIPAEngine(&OTDlg);
	if(OTDlg.DoModal() != IDOK)
	{
		delete pOutputTag;
		ResetViewItem();
		return;
	}

	CXISLActTag *pActTag;
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	int nXISLType = m_pTargetTag->m_nTagType;

	if(nXISLType == ID_TAG_EXCHANGE || nXISLType == ID_TAG_PROMPT)
	{
		if(nXISLType == ID_TAG_EXCHANGE)
			pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		else if(nXISLType == ID_TAG_PROMPT)
			pActTag = ((CXISLPrompt*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pOutputTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pOutputTag);
		pOutputTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pOutputTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);


	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)pOutputTag;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pOutputTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	m_bDropOK = TRUE;
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::InsertOutputBrowser()
{
	ASSERT(m_pMODlg);

	CXISLActTag *pActTag;
	CXISLOutputBrowser *pOutputTag = m_pMODlg->m_pOutputTag;
	m_pTargetTag = m_pMODlg->m_pCurrentTag;
	
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = m_pTargetTag->m_htreeItem;

	int nXISLType = m_pTargetTag->m_nTagType;
	if(nXISLType == ID_TAG_EXCHANGE || nXISLType == ID_TAG_PROMPT)
	{
		if(nXISLType == ID_TAG_EXCHANGE)
			pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		else if(nXISLType == ID_TAG_PROMPT)
			pActTag = ((CXISLPrompt*)m_pTargetTag)->m_pXISLAct;
		if(pActTag)
			hParent = pActTag->m_htreeItem;
		else
			ASSERT(NULL);

		pActTag->InsertActItem(pOutputTag);
	}
	else if(nXISLType == ID_TAG_ACTION || nXISLType == ID_TAG_CASE || nXISLType == ID_TAG_OTHER || nXISLType == ID_TAG_ELSE || nXISLType == ID_TAG_THEN)
	{
		((CXISLActTag*)m_pTargetTag)->InsertActItem(pOutputTag);
		pOutputTag->m_pParentTag = m_pTargetTag;
		hParent = m_pTargetTag->m_htreeItem;
	}
	else if(nXISLType == ID_TAG_BEGIN || nXISLType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)m_pTargetTag)->InsertActItem(pOutputTag);
		hParent = m_pTargetTag->m_htreeItem;
	}
	else
		ASSERT(NULL);

	((CXISLDialogTag*)m_pTargetTag->GetParentDialogTag())->SetBrowserData(pOutputTag->GetURI(),pOutputTag->GetWindowName());
	//c[ɓo^
	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	tvs.hParent = hParent;
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)pOutputTag;
	tvi.iImage = 0; 
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	pOutputTag->m_htreeItem = pIToolView->m_treeInteraction.InsertItem(&tvs);

	m_pMODlg->DestroyWindow();
	m_pMODlg = NULL;
	m_bDropOK = TRUE;
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeDialogParam()
{
	ASSERT(m_pSelectTag);
	CXISLDialogTag *pTag = (CXISLDialogTag*)m_pSelectTag;
	CXISLDialogDlg DialogDlg(pTag,this);
	CString strTempID = pTag->GetDialogID();

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);
	while(1)
	{
		if(DialogDlg.DoModal() != IDOK)
		{
			ResetViewItem();
			return;
		}
/*
		if(strTempID != DialogDlg.m_strID)
		{
			if(pDoc->m_pXISLRoot->FindDTag(DialogDlg.m_strID))
			{
				AfxMessageBox("Dialog ID͊ɓo^Ă܂B\r\nʂIDgpĂ",
					MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				continue;
			}
		}
*/
		if(pTag->IsValid())
			break;
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeExchangeParam()
{
	ASSERT(m_pSelectTag);
	CXISLExchangeTag *pTag = (CXISLExchangeTag*)m_pSelectTag;

	CXISLExchangeDlg ExcDlg;
	ExcDlg.m_nCombGlp = pTag->m_pXISLOpr->GetComb();
	UpdateData(FALSE);
	if(ExcDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	pTag->m_pXISLOpr->SetComb(ExcDlg.m_nCombGlp);

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);

}

void CIBFlowView::ChangePromptParam(CXISLPrompt *pPromptTag)
{
	ASSERT(m_pSelectTag);
	CXISLPromptDlg PDlg(pPromptTag);
	if(PDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeCallParam(CXISLCallTag *pCallTag)
{
	m_pTargetTag = pCallTag->m_pParentTag;
	CXISLCallDlg CallDlg(pCallTag,m_pTargetTag);

	CallDlg.m_pParentView = this;
	if(CallDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeReturnParam(CXISLReturnTag *pReturnTag)
{
	m_pTargetTag = pReturnTag->m_pParentTag;
	CXISLReturnDlg RetDlg(pReturnTag,m_pTargetTag);

	if(RetDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeSwitchParam(CXISLSwitchTag *pSwitchTag)
{
	m_pTargetTag = pSwitchTag->m_pParentTag;
	CXISLSwitchDlg SWDlg(pSwitchTag,m_pTargetTag);

	if(SWDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeInputParam(CXISLInputTag *pInputTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pInputTag->m_pParentTag;
	if(m_pTargetTag->m_nTagType != ID_TAG_EXCHANGE && m_pTargetTag->m_nTagType != ID_TAG_AINPUT
		&& m_pTargetTag->m_nTagType != ID_TAG_SINPUT && m_pTargetTag->m_nTagType != ID_TAG_PINPUT)
		ASSERT(NULL);

	int nType = pInputTag->GetInputType();
	if(nType == ID_INPUTTYPE_SPEECH)
	{
		CSpeechInputDlg SIDlg((CXISLSpeechInputTag*)pInputTag,m_pTargetTag);

		SIDlg.m_pParent = this;
		if(SIDlg.DoModal() != IDOK)
		{
			ResetViewItem();
			return;
		}
	}
	else if(nType == ID_INPUTTYPE_TOUCH)
	{
		if(!m_bDropOK)
			return;
		m_pTIDlg = new CTouchInputDlg((CXISLTouchInputTag*)pInputTag,m_pTargetTag,FALSE,(CWnd*)this);
		m_pTIDlg->ShowWindow(SW_SHOW);
		m_bDropOK = FALSE;
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeOutputParam(CXISLOutputTag *pOutputTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pOutputTag->m_pParentTag;

	int nType = pOutputTag->GetOutputType();
	if(nType == ID_OUTPUTTYPE_TTS)
	{
		COutputTTSDlg TODlg((CXISLOutputTTS*)pOutputTag,m_pTargetTag);
		TODlg.m_pParent = this;
		if(TODlg.DoModal() != IDOK)
		{
			ResetViewItem();
			return;
		}
	}
	if(nType == ID_OUTPUTTYPE_AGENT)
	{
		CFSMOutputDlg FODlg((CXISLOutputFSM*)pOutputTag,m_pTargetTag);
		FODlg.m_pParent = this;
//		((CMainFrame*)AfxGetMainWnd())->ConnectIPAEngine(&FODlg);
		if(FODlg.DoModal() != IDOK)
		{
			ResetViewItem();
			return;
		}
	}
	else if(nType == ID_OUTPUTTYPE_BROWSER)
	{
		if(!m_bDropOK)
			return;
		m_pMODlg = new CMMIBrowserOutputDlg((CXISLOutputBrowser*)pOutputTag,m_pTargetTag,FALSE,this);
		m_pMODlg->ShowWindow(SW_SHOW);
		m_bDropOK = FALSE;
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeAssignParam(CXISLAssignTag *pAssignTag)
{
	m_pTargetTag = pAssignTag->m_pParentTag;
	CXISLAssignDlg ADlg(pAssignTag,m_pTargetTag);

	if(ADlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::ChangeIfParam(CXISLIfTag *pIfTag)
{
	m_pTargetTag = pIfTag->m_pParentTag;
	
	CXISLIFDlg IFDlg(pIfTag,m_pTargetTag);
	if(IFDlg.DoModal() != IDOK)
	{
		ResetViewItem();
		return;
	}

	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}
//void CIBFlowView::SetSelectedPath(LPCTSTR lpszSelectedPath)
//@\@Fe_CAOɑIIuWFNg̃pXݒ
//@FlpszSelectedPath:IuWFNg̃pX
//ԂlF
void CIBFlowView::SetSelectedPath(LPCTSTR lpszSelectedPath)
{
	if(m_pTIDlg)
		m_pTIDlg->SetMatch(lpszSelectedPath);
}

//void CIBFlowView::SetSelectedPath(LPCTSTR lpszSelectedPath)
//@\@Fe_CAOɑItH[IuWFNg̃pXݒ
//@FlpszSelectedPath:IuWFNg̃pX
//ԂlF
void CIBFlowView::SetSelectedFormPath(LPCTSTR lpszSelectedPath,LPCTSTR lpszFilePath)
{
	if(m_pMODlg)
		m_pMODlg->SetFormID(lpszSelectedPath,lpszFilePath);
}

/////////////////////////////////////////////////////////////////////////////
// CIBFlowView `

void CIBFlowView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: ̃r[Ŝ̃TCYvZĂB
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CIBFlowView::OnDraw(CDC* pDC)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
	if(!pDoc->m_pXISLRoot)
		return;

//	m_pParentTag = NULL;
//	m_pDrawingTag = pIToolView->m_pSelectXISLTag;

	if(m_pDrawingTag == NULL)
	{
		((CMainFrame*)AfxGetMainWnd())->SetBarItem(ID_DROPOK_DIALOG);
		return;
	}

	CString strText;
	CSize sizeTotal(0,0);
	int nDropOKItem = 0;
	int nTagType = m_pDrawingTag->m_nTagType;
	if(nTagType == ID_TAG_BODY || nTagType == ID_TAG_XISL)
	{
		nDropOKItem = ID_DROPOK_DIALOG;
		sizeTotal = pDoc->m_pXISLRoot->DrawXISLFlow(pDC,100,10);
		strText = ((CXISLRootTag*)m_pDrawingTag)->GetDocName();
//		int nDialogNum = pDoc->m_pXISLRoot->m_xislList.GetCount();
//		nDropOKItem = ID_DROPOK_DIALOG|ID_DROPOK_EXCHANGE|ID_DROPOK_BEGIN|ID_DROPOK_END
//						|ID_DROPOK_SEQ|ID_DROPOK_PAR|ID_DROPOK_ALT;
/*
		for(int i=0;i<nDialogNum;i++)
		{
			POSITION pos = pDoc->m_pXISLRoot->m_xislList.FindIndex(i);
			CXISLDialogTag *pDialog = (CXISLDialogTag*)pDoc->m_pXISLRoot->m_xislList.GetAt(pos);

			sizeTotal = pDialog->DrawXISLFlow(pDC,30,sizeTotal.cy);
		}
*/
	}
	else
	{
		CXISLDialogTag *pDTag =  (CXISLDialogTag*)m_pDrawingTag->GetParentDialogTag();
		strText = "dialog ID: ";
		strText += pDTag->GetDialogID();
		if(pDTag->IsSubDialog())
			strText += "\nThis dialog is called from another dialog.";
		else
			strText += "\nThis dialog in not called.";

		if(nTagType == ID_TAG_DIALOG)
			nDropOKItem = ID_DROPOK_EXCHANGE|ID_DROPOK_BEGIN|ID_DROPOK_END|ID_DROPOK_COMB;
		else if(nTagType == ID_TAG_BEGIN || nTagType == ID_TAG_END  || nTagType == ID_TAG_CASE || nTagType == ID_TAG_OTHER || nTagType == ID_TAG_THEN || nTagType == ID_TAG_ELSE)
		{
			nDropOKItem = ID_DROPOK_OUTPUT|ID_DROPOK_ACTION;
			if(!((CXISLDialogTag*)m_pDrawingTag->GetParentDialogTag())->IsSubDialog())
				nDropOKItem ^= ID_DROPOK_RETURN;
		}
		else if(nTagType == ID_TAG_EXCHANGE)
		{
			nDropOKItem = ID_DROPOK_COMB|ID_DROPOK_MODALLOK|ID_DROPOK_ACTION | ID_DROPOK_PROMPT;
			if(!((CXISLDialogTag*)m_pDrawingTag->GetParentDialogTag())->IsSubDialog())
				nDropOKItem ^= ID_DROPOK_RETURN;
			else if(((CXISLExchangeTag *)m_pDrawingTag)->m_XISLPromptList.IsEmpty()==0)
				nDropOKItem ^= ID_DROPOK_REPROMPT;
		}
		else if(nTagType == ID_TAG_SEXCHANGE || nTagType == ID_TAG_PEXCHANGE || nTagType == ID_TAG_AEXCHANGE)
			nDropOKItem = ID_DROPOK_EXCHANGE|ID_DROPOK_COMB;
		else if(nTagType == ID_TAG_PROMPT )
			nDropOKItem = ID_DROPOK_OUTPUT;
		else if(nTagType == ID_TAG_AINPUT || nTagType == ID_TAG_SINPUT || nTagType == ID_TAG_PINPUT )
			nDropOKItem = ID_DROPOK_INPUT|ID_DROPOK_COMB;
		//ELSEIF΍(ł͖{^OuȂ)
		//܂AIF^OTHENEELSEEELSEIF^O͒uȂ
		//̉@2003/5/30@
		else if(nTagType == ID_TAG_IF || nTagType == ID_TAG_ELSEIF)
			nDropOKItem = ID_DROPOK_IF;
		sizeTotal = m_pDrawingTag->DrawXISLFlow(pDC,100,10);
	}
	SetScrollSizes(MM_TEXT,sizeTotal);

	if(m_bViewActive)
		((CMainFrame*)AfxGetMainWnd())->SetBarItem(nDropOKItem);

	if(m_pSelectTag)
	{
		CRect rect;
		m_pSelectTag->GetRectBMP(&rect);
		pDC->InvertRect(&rect);
	}

	CFont *pOldFont;
	CFont font;
	font.CreateFont(12,0,0,0,FW_BOLD,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
		DRAFT_QUALITY,DEFAULT_PITCH,_T("lr oSVbN"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetTextColor(RGB(80,80,80));
	pDC->SetBkMode(TRANSPARENT);
	CRect rect;
	GetClientRect(&rect);
	rect.top = rect.top + 10;
	rect.right -= 10;
	pDC->DrawText(strText,rect,DT_RIGHT|DT_NOCLIP|DT_VCENTER);
}

/////////////////////////////////////////////////////////////////////////////
// CIBFlowView ff

#ifdef _DEBUG
void CIBFlowView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CIBFlowView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CIBFlowView bZ[W nh
void CIBFlowView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	((CMainFrame*)AfxGetMainWnd())->SetBarItem(0);
	((CMainFrame*)AfxGetMainWnd())->SetSendTCPMessageTarget(NULL);
}

void CIBFlowView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(bActivate)
	{
		TRACE("CIBFlowView::OnActivateView!!\n");
		m_bViewActive = TRUE;
		((CMainFrame*)AfxGetMainWnd())->SetSendTCPMessageTarget(this);
		g_pOprTargetView = this;
		pIToolView->SendMessage(MY_UPDATE_VIEW,(WPARAM)GetDocument());
		if(m_pDrawingTag)
		{
			pIToolView->m_bReDrawView = FALSE;
			pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
		}
	}
	else
	{
		TRACE("CIBFlowView::NoActivateView!!\n");
		m_bViewActive = FALSE;
	}
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

int CIBFlowView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ
	if( !m_dropTarget.Register( this ) )     // hbv^[Qbgւ̓o^
		return -1;

	TRACE("CIBFlowView::쐬\n");
	return 0;
}

void CIBFlowView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
//	((CMainFrame*)AfxGetMainWnd())->SetBarItem(m_nDropOKItem);
	
	TRACE("CIBFlowView::OnUpdate!!\n");
	if( !((int)lHint & ID_VIEW_FLOW) )
		return;

	if( ((int)lHint & ID_VIEW_INTERACTION) )
		m_pDrawingTag = pIToolView->m_pSelectXISLTag;

	m_pSelectTag = NULL;//pIToolView->m_pSelectXISLTag;
	InvalidateRect(NULL);
}

void CIBFlowView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	if(!m_bDropOK)
		return;

	CXISLDoc *pDoc = (CXISLDoc*)GetDocument();
	CPoint scPoint = GetScrollPosition();
	point += scPoint;

	if(m_pDrawingTag)
	{
		m_pSelectTag = m_pDrawingTag->FindTag(point);
		if(m_pSelectTag)
		{
			int nSType = m_pSelectTag->m_nTagType;
			if(m_pDrawingTag == m_pSelectTag)
				m_pDrawingTag = m_pSelectTag->m_pParentTag;
			else
			{
				if(nSType == ID_TAG_CALL || nSType == ID_TAG_GOTO)
				{
					CXISLDialogTag *pDTag;
					pDTag = ((CXISLCallTag*)m_pSelectTag)->m_pNextDialog;

					CString strDocName = pDTag->GetDocName();
					strDocName.Delete(strDocName.GetLength()-5,5);
					if(strDocName.Compare(pDoc->GetTitle()) == 0)
						m_pDrawingTag = pDTag;
					else
					{
						CMainFrame *pFrame = (CMainFrame*)AfxGetMainWnd();
						pFrame->SetActiveWnd(strDocName,pDTag);
					}
				}
				else if(nSType == ID_TAG_RETURN)
				{
					CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pDrawingTag->GetParentDialogTag();
					CReCallListDlg *pReCallDlg = new CReCallListDlg(m_pDrawingTag,pDTag,this);
					pReCallDlg->ShowWindow(SW_SHOW);
					m_bDropOK = FALSE;
					return;
				}
				else if(nSType != ID_TAG_INPUT && nSType != ID_TAG_OUTPUT
					&& nSType != ID_TAG_ASSIGN && nSType != ID_TAG_EXIT
					&& nSType != ID_TAG_REPROMPT)
					m_pDrawingTag = m_pSelectTag;
			}
		
			pIToolView->m_bReDrawView = FALSE;
			pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
			/*if(pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem)==0){
				MessageBox("c[\ɖŃ^O̖O擾ł܂","TagName Lost in Tree",MB_OK);
				return;
			}*/

			m_pSelectTag = NULL;
		}

		InvalidateRect(NULL);
	}
	CScrollView::OnLButtonDblClk(nFlags, point);
}

void CIBFlowView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CPoint scPoint = GetScrollPosition();
	point += scPoint;

//	if(!m_bDropOK)
//		return;

	if(m_pDrawingTag)
	{
		m_pSelectTag = m_pDrawingTag->FindTag(point);

//		if(m_pSelectTag)
			InvalidateRect(NULL);
	}

	CScrollView::OnLButtonDown(nFlags, point);
}

void CIBFlowView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	if(!m_bDropOK)
		return;

	CPoint scPoint = GetScrollPosition();
	point += scPoint;

	if(m_pDrawingTag)
	{
		m_pSelectTag = m_pDrawingTag->FindTag(point);
		if(m_pSelectTag)
		{
			InvalidateRect(NULL);
			
			CMenu menu;
			VERIFY(menu.LoadMenu(IDR_TAG_MENU));
			CMenu* pPopup = menu.GetSubMenu(0);
			ASSERT(pPopup != NULL);

			CPoint point;
			GetCursorPos(&point);
			
			//pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			//	 point.x, point.y, AfxGetMainWnd());
			
			//t@Cړj[\
			CMenu* psPopup = pPopup->GetSubMenu(2);
			CWinApp *pApp = AfxGetApp();
			POSITION pos = pApp->GetFirstDocTemplatePosition();
			int i=0;
			for(i;pos!=NULL;i++){
				CDocTemplate* pTemplate = pApp->GetNextDocTemplate(pos);
				POSITION tpos = pTemplate->GetFirstDocPosition();
				m_XislFileCont=0;
				for(m_XislFileCont;tpos!=NULL;m_XislFileCont++){
					//hLgj[ɒǉ
					CXISLDoc *pDoc = (CXISLDoc *)pTemplate->GetNextDoc(tpos);
					CString str = pDoc->GetTitle();
					MENUITEMINFO mii;
					ZeroMemory(&mii,sizeof(mii));
					mii.cbSize = sizeof(mii);
					mii.fMask = MIIM_TYPE | MIIM_ID;
					mii.fType = MFT_STRING;
					mii.dwTypeData = str.GetBuffer(str.GetLength());
					mii.wID = IDM_TAB_XISLFILES+m_XislFileCont;
					InsertMenuItem(psPopup->GetSafeHmenu(),IDM_TAB_XISLFILES+m_XislFileCont,MF_BYPOSITION,&mii);
					//݃ANeBuȃEBhEɃ`FbN
					if(pDoc == (CXISLDoc *)GetDocument()){
						psPopup->DeleteMenu(0,MF_BYPOSITION);
						//pPopup->EnableMenuItem(IDM_TAB_XISLFILES+m_XislFileCont,TRUE);
						psPopup->CheckMenuItem(m_XislFileCont,MF_BYPOSITION | MF_CHECKED);
					}
				}
			}
			//psPopup->DeleteMenu(0,MF_BYPOSITION);
			pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, AfxGetMainWnd());
		}
	}

	CScrollView::OnRButtonDown(nFlags, point);
}

//^ȎύX
void CIBFlowView::OnTagProperty() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	int nTagType = m_pSelectTag->m_nTagType;
	switch(nTagType)
	{
	case ID_TAG_DIALOG:
		ChangeDialogParam();
		break;
	case ID_TAG_EXCHANGE:
		ChangeExchangeParam();
		break;
	case ID_TAG_PROMPT:
		ChangePromptParam((CXISLPrompt*)m_pSelectTag);
		break;
	//CALLGOTO͓
	case ID_TAG_CALL:
	case ID_TAG_GOTO:
		ChangeCallParam((CXISLCallTag*)m_pSelectTag);
		break;
	case ID_TAG_RETURN:
		ChangeReturnParam((CXISLReturnTag*)m_pSelectTag);
		break;
	case ID_TAG_INPUT:
		ChangeInputParam((CXISLInputTag*)m_pSelectTag);
		break;
	case ID_TAG_OUTPUT:
		ChangeOutputParam((CXISLOutputTag*)m_pSelectTag);
		break;
	case ID_TAG_SWITCH:
		ChangeSwitchParam((CXISLSwitchTag*)m_pSelectTag);
		break;
	case ID_TAG_ASSIGN:
		ChangeAssignParam((CXISLAssignTag *)m_pSelectTag);
		break;
	case ID_TAG_IF:
	case ID_TAG_ELSEIF:
		ChangeIfParam((CXISLIfTag *)m_pSelectTag);
		break;
	default:
		break;
	}
	GetDocument()->SetModifiedFlag(TRUE);
}

//^ȎύXڂ̗L/(ɗL)
void CIBFlowView::OnUpdateTagProperty(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
		// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	int nDType = m_pDrawingTag->m_nTagType;
	int nSType = m_pSelectTag->m_nTagType;
	if(nSType == ID_TAG_EXIT || nSType == ID_TAG_REPROMPT)
		pCmdUI->Enable(FALSE);
}

//̊Kwֈړ
void CIBFlowView::OnTagGoParent() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	m_pDrawingTag = m_pSelectTag->m_pParentTag;
	m_pSelectTag = NULL;
	pIToolView->m_bReDrawView = FALSE;
	pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
	InvalidateRect(NULL);
}

//̊Kwֈړڂ̗L/
void CIBFlowView::OnUpdateTagGoParent(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	int nDType = m_pDrawingTag->m_nTagType;
	int nSType = m_pSelectTag->m_nTagType;
	if((m_pDrawingTag != m_pSelectTag) || (nDType == ID_TAG_XISL || nDType == ID_TAG_BODY))
	{
		if((nDType != ID_TAG_OPERATION) && (nDType != ID_TAG_ACTION)){
			pCmdUI->Enable(FALSE);
		}
	}
}

//̊Kwֈړ
void CIBFlowView::OnTagGoChild() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	m_pDrawingTag = m_pSelectTag;
	m_pSelectTag = NULL;
	pIToolView->m_bReDrawView = FALSE;
	pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
	InvalidateRect(NULL);
}

//̊Kwֈړڂ̗L/
void CIBFlowView::OnUpdateTagGoChild(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	int nDType = m_pDrawingTag->m_nTagType;
	int nSType = m_pSelectTag->m_nTagType;
	if(!((m_pDrawingTag != m_pSelectTag) && (nDType != ID_TAG_EXCHANGE)) || nDType == ID_TAG_OPERATION || nDType == ID_TAG_ACTION || nDType == ID_TAG_EXIT || nDType == ID_TAG_REPROMPT || nDType == ID_TAG_PROMPT)
		pCmdUI->Enable(FALSE);
}

void CIBFlowView::OnTabGoNextXISL()
{
	MessageBox("(ÉE)!!",NULL,MB_OK);
}
//obNOEh̍ĕ`
BOOL CIBFlowView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	// uV쐬
	if(!m_bAppRoot)
		return CScrollView::OnEraseBkgnd(pDC);

    CBrush backBrush(RGB(255,255,255));

    // VuVI ݂̃uVۑ
    CBrush* pOldBrush = pDC->SelectObject(&backBrush);

    // ݂̃NbsÖ̋`擾
    CRect rect;
    pDC->GetClipBox(&rect);

    // `hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	CPen backPen(PS_SOLID,4,RGB(100,100,100));
	CPen *pOldPen = pDC->SelectObject(&backPen);
	GetClientRect(&rect);

	rect.DeflateRect(2,2);
	pDC->Rectangle(rect);
    // uVɖ߂
    pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);

	backPen.DeleteObject();
	backBrush.DeleteObject();

    return TRUE;
	
//	return CScrollView::OnEraseBkgnd(pDC);
}

//wb__CAŐN
void CIBFlowView::OnXislHead() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CXISLHeadDlg HeadDlg;
	HeadDlg.DoModal();
}


DROPEFFECT CIBFlowView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
//	ResetViewItem(FALSE);
	return CScrollView::OnDragEnter(pDataObject, dwKeyState, point);
}

//J[\L͈͊Oɏȍ
void CIBFlowView::OnDragLeave() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	//ȑOɃnCCgɂĂ^Oɖ߂
	if(m_pHighlightTag)
	{
		CDC *pDC = GetDC();
		CRect rect;
		m_pHighlightTag->GetRectBMP(&rect);
		pDC->InvertRect(&rect);
		m_pHighlightTag = NULL;
	}
	m_pSelectTag = NULL;
	CScrollView::OnDragLeave();
}

//^Ot[EBhEɃhbOꂽ̏
DROPEFFECT CIBFlowView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(g_pOprTargetView != this)
		return DROPEFFECT_NONE;
	if(!m_bDropOK)
		return DROPEFFECT_NONE;
	//݂̐Aʒu̎擾
	CPoint scPoint = GetScrollPosition();
	//ʒu̍Đݒ
	point += scPoint;

	//O[of[^(ݑI𒆂̃^Ow)bN
	HGLOBAL hGlobal = pDataObject->GetGlobalData(CF_TEXT);
	const char *pcstrType = (const char *)GlobalLock(hGlobal);
	int nType = atoi(pcstrType);
	GlobalUnlock(hGlobal);

	CDC *pDC = GetDC();
	CRect rect;

	//^ODialog̏ꍇJ[\̕ύX
	if(nType & ID_DROPOK_DIALOG)
		return DROPEFFECT_MOVE;

	//ȑOɃnCCgɂĂ^Oɖ߂
	if(m_pHighlightTag)
	{
		m_pHighlightTag->GetRectBMP(&rect);
		pDC->InvertRect(&rect);
		m_pHighlightTag=NULL;
	}
	//t[ɊɑIĂ^OꍇI
	if(m_pSelectTag)
	{
		//IĂ^OBMP̎擾
		m_pSelectTag->GetRectBMP(&rect);
		//F̔]
		pDC->InvertRect(&rect);
		m_pSelectTag=NULL;
	}

	//|CgɃ^O邩H
	m_pHighlightTag = m_pDrawingTag->FindTag(point);
	if(m_pHighlightTag)
	{
		int nTagType = m_pHighlightTag->m_nTagType;
		//hbvACeCombH
		if(nType & (ID_DROPOK_COMB))
		{
			//begin^Oend^Oɂ͕t܂
			if(nTagType == ID_TAG_BEGIN || nTagType == ID_TAG_END || nTagType >= ID_TAG_ACTION )
			{
				m_pHighlightTag = NULL;
				return DROPEFFECT_NONE;
			}
		}
		else if(nType & (ID_DROPOK_INPUT))
		{
			//inputexchangeC***_inputȊOɂ͑}ł܂
			if(nTagType != ID_TAG_EXCHANGE && nTagType != ID_TAG_SINPUT
				&& nTagType != ID_TAG_PINPUT && nTagType != ID_TAG_AINPUT)
			{
				m_pHighlightTag = NULL;
				return DROPEFFECT_NONE;
			}
		}
		else if(nType & (ID_DROPOK_OUTPUT)){
			if(nTagType != ID_TAG_EXCHANGE && nTagType != ID_TAG_PROMPT && nTagType != ID_TAG_BEGIN && nTagType != ID_TAG_END && nTagType != ID_TAG_CASE)
			{
				m_pHighlightTag = NULL;
				return DROPEFFECT_NONE;
			}
		}
		else
		{
			//e^Oɂhbvł܂
			if(m_pHighlightTag != m_pDrawingTag)
			{
				m_pHighlightTag = NULL;
				return DROPEFFECT_NONE;
			}
		}
		m_pHighlightTag->GetRectBMP(&rect);
		pDC->InvertRect(&rect);

		return DROPEFFECT_MOVE;
	}
	else
	{
		m_pHighlightTag = NULL;
		return DROPEFFECT_NONE;
	}

//	return CScrollView::OnDragOver(pDataObject, dwKeyState, point);
}

//^Õhbv̏
BOOL CIBFlowView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	HGLOBAL hGlobal = pDataObject->GetGlobalData(CF_TEXT);
	const char *pcstrType = (const char *)GlobalLock(hGlobal);
	int nType = atoi(pcstrType);
	GlobalUnlock(hGlobal);

	//^[QbgnCCg^Oɐݒ肵Ă^Oɒ߂
	m_pTargetTag = m_pHighlightTag;
	//o̓^O̐ݒ(switchł͋LqłȂ̂)
	CXISLTouchInputTag *pInputTag=NULL;
	CXISLOutputAgent *pAOTag=NULL;
	CXISLOutputBrowser *pBOTag=NULL;
	//hbv^O̒gɂď𕪂
	switch(nType)
	{
	case ID_DROPOK_DIALOG:
		XislDialogInsert();
		break;
	case ID_DROPOK_EXCHANGE:
		XislExchangeInsert();
		break;
	case ID_DROPOK_BEGIN:
		XislBeginInsert();
		break;
	case ID_DROPOK_END:
		XislEndInsert();
		break;
	case ID_DROPOK_SEQ:
		XislCombInsert(ID_TAG_SEQ);
		break;
	case ID_DROPOK_PAR:
		XislCombInsert(ID_TAG_PAR);
		break;
	case ID_DROPOK_ALT:
		XislCombInsert(ID_TAG_ALT);
		break;
	case ID_DROPOK_PROMPT:
		XislPromptInsert();
		break;
	case ID_DROPOK_REPROMPT:
		XislRepromptInsert();
		break;
	case ID_DROPOK_CALL:
		XislCallInsert(ID_TAG_CALL);
		break;
	case ID_DROPOK_GOTO:
		XislCallInsert(ID_TAG_GOTO);
		break;
	case ID_DROPOK_RETURN:
		XislReturnInsert();
		break;
	case ID_DROPOK_ASSIGN:
		XislAssignInsert();
		break;
	case ID_DROPOK_SWITCH:
		XislSwitchInsert();
		break;
	case ID_DROPOK_IF:
		XislIfInsert();
		break;
	case ID_DROPOK_EXIT:
		XislExitInsert();
		break;
	case ID_DROPOK_SPEECH:
		InsertInputSpeech();
		break;
	case ID_DROPOK_TOUCH:
		pInputTag = new CXISLTouchInputTag();
		m_pTIDlg = new CTouchInputDlg(pInputTag,m_pTargetTag,TRUE,(CWnd*)this);
		m_pTIDlg->ShowWindow(SW_SHOW);
		m_bDropOK = FALSE;
		break;
	case ID_DROPOK_WINDOW:
		pBOTag = new CXISLOutputBrowser;
		m_pMODlg = new CMMIBrowserOutputDlg(pBOTag,m_pTargetTag,TRUE,this);
		m_pMODlg->ShowWindow(SW_SHOW);
		m_bDropOK = FALSE;
		break;
	case ID_DROPOK_TTS:
		InsertOutputTTS();
		break;
	case ID_DROPOK_FSM:
		InsertOutputFSM();
		break;
	default:
		ASSERT(NULL);
	}

	GetDocument()->SetModifiedFlag(TRUE);
//	ResetViewItem();
	return CScrollView::OnDrop(pDataObject, dropEffect, point);
}



//eXgpj[
void CIBFlowView::OnTestSelecteditem() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CString strTemp;
	if(m_pSelectTag)
	{
		strTemp += "\r\n";
		strTemp += XISL_TAG_NAME[m_pSelectTag->m_nTagType];
		if(m_pHighlightTag)
		{
			strTemp += "\r\nnCCg\:";
			strTemp += XISL_TAG_NAME[m_pHighlightTag->m_nTagType];
		}
		else
			strTemp += "\r\nnCCg\Ȃ";

		AfxMessageBox(strTemp);
	}
	else
	{
		strTemp = "Ȃ";
		if(m_pHighlightTag)
		{
			strTemp += "\r\nnCCg\:";
			strTemp += XISL_TAG_NAME[m_pHighlightTag->m_nTagType];
		}
		else
			strTemp += "\r\nnCCg\Ȃ";

		AfxMessageBox(strTemp);
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//
//	폜֘A\bh
//
//////////////////////////////////////////////////////////////////////////////////////////////////

//^O̍폜
//2003/5/12@
void CIBFlowView::OnTagDelete() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	int mesid;
	mesid = MessageBox("Iꂽ^O폜܂B낵łH","^O̍폜",MB_ICONWARNING || MB_OKCANCEL);
	if(mesid == IDCANCEL){
		return;
	}
	int nTagType = m_pSelectTag->m_nTagType;
	switch(nTagType)
	{
	case ID_TAG_DIALOG:
		//DIALOG̍폜
		DeleteDialog((CXISLDialogTag *)m_pSelectTag);
		break;
	case ID_TAG_BEGIN:
	case ID_TAG_END:
		DeleteBeginEnd((CXISLBeginEndTag *)m_pSelectTag);
		break;
	case ID_TAG_EXCHANGE:
		//EXCHANGE̍폜
		DeleteExchange((CXISLExchangeTag *)m_pSelectTag);
		break;
	case ID_TAG_AEXCHANGE:
	case ID_TAG_SEXCHANGE:
	case ID_TAG_PEXCHANGE:
		DeleteCombExchange((CXISLCombExchangeTag *)m_pSelectTag);
		break;
	case ID_TAG_PROMPT:
		//Prompt̍폜
		DeletePrompt((CXISLPrompt *)m_pSelectTag);
		break;
	case ID_TAG_REPROMPT:
		DeleteReprompt((CXISLRepromptTag *)m_pSelectTag);
		break;
	//CALLGOTO͓
	case ID_TAG_CALL:
	case ID_TAG_GOTO:
		//CALLGOTO̍폜
		DeleteCall((CXISLCallTag *)m_pSelectTag);
		break;
	case ID_TAG_RETURN:
		//RETURN̍폜
		DeleteReturn((CXISLReturnTag *)m_pSelectTag);
		break;
	case ID_TAG_ASSIGN:
		DeleteAssign((CXISLAssignTag *)m_pSelectTag);
		break;
	case ID_TAG_INPUT:
		//INPUT̍폜
		DeleteInput((CXISLInputTag*)m_pSelectTag);
		break;
	case ID_TAG_SINPUT:
	case ID_TAG_PINPUT:
	case ID_TAG_AINPUT:
		//CombInput(Ǐ)̍폜
		DeleteCombInput((CXISLCombInputTag*)m_pSelectTag);
		break;
	case ID_TAG_OUTPUT:
		//OUTPUT̍폜
		DeleteOutput((CXISLOutputTag*)m_pSelectTag); 
		break;
	case ID_TAG_SWITCH:
		//SWITCH̍폜
		DeleteSwitch((CXISLSwitchTag *)m_pSelectTag);
		//MessageBox("Switch Tag Delete!!","^O̍폜",MB_OK);
		break;
	case ID_TAG_CASE:
	case ID_TAG_OTHER:
		//Case&Other^O̍폜
		DeleteCase((CXISLCaseTag *)m_pSelectTag);
		break;
	case ID_TAG_IF:
	case ID_TAG_ELSEIF:
		DeleteIf((CXISLIfTag *)m_pSelectTag);
		break;
	case ID_TAG_ELSE:
	case ID_TAG_THEN:
		DeleteThenElse((CXISLIfChildTag *)m_pSelectTag);
		break;
	case ID_TAG_EXIT:
		//Exit^O̍폜
		DeleteExit((CXISLExitTag *)m_pSelectTag);
		break;
	default:
		break;
	}
	GetDocument()->SetModifiedFlag(TRUE);
}

//^O̍폜ڂ̗L/̐ݒ(ɗL)
//2003/5/12@
void CIBFlowView::OnUpdateTagDelete(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

//Input^O폜
//2003/5/13@
void CIBFlowView::DeleteInput(CXISLInputTag *pInputTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pInputTag->m_pParentTag;
	//ȉ̎l̑SĂ̑ɂĂ͂܂ȂH
	if(m_pTargetTag->m_nTagType != ID_TAG_EXCHANGE && m_pTargetTag->m_nTagType != ID_TAG_AINPUT
		&& m_pTargetTag->m_nTagType != ID_TAG_SINPUT && m_pTargetTag->m_nTagType != ID_TAG_PINPUT)
		ASSERT(NULL);

	//Input^ȎOExchange^Ȍꍇ
	if(m_pTargetTag->m_nTagType==ID_TAG_EXCHANGE){
		pIToolView->m_treeInteraction.DeleteItem(pInputTag->m_htreeItem);
		if((((CXISLExchangeTag*)m_pTargetTag)->m_pXISLOpr)->DeleteOprItem(pInputTag) == FALSE){
				MessageBox("Ȃ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
			}
	}
	//Input^ȎOǏύX^Ȍꍇ
	else if(m_pTargetTag->m_nTagType == ID_TAG_SINPUT || m_pTargetTag->m_nTagType == ID_TAG_AINPUT || m_pTargetTag->m_nTagType == ID_TAG_PINPUT)
	{
		pIToolView->m_treeInteraction.DeleteItem(pInputTag->m_htreeItem);
		if(((CXISLCombInputTag*)m_pTargetTag)->DeleteOprItem(pInputTag) == FALSE){
				MessageBox("Ȃ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
			}
	}

	//ĕ`揈
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Ǐ̓^O̍폜
//2003/5/15@
void CIBFlowView::DeleteCombInput(CXISLCombInputTag *pCombInputTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pCombInputTag->m_pParentTag;

	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == m_pSelectTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	/*if(m_pTargetTag->m_nTagType==ID_TAG_DIALOG){
		pIToolView->m_treeInteraction.DeleteItem(pCombInputTag->m_htreeItem);
		pCombInputTag->DeleteCombInputList();
	}*/
	//eExchange^Ȍꍇ
	if(m_pTargetTag->m_nTagType==ID_TAG_EXCHANGE){
		//Input^OȂ
		pIToolView->m_treeInteraction.DeleteItem(pCombInputTag->m_htreeItem);
		pCombInputTag->DeleteCombInputList();
		CXISLOprTag *pOprTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLOpr; 
		if(pOprTag->DeleteOprItem(pCombInputTag) == FALSE){
			MessageBox("ERROR:COMBDELL-ID_TAGEXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//eseq or alt or par_input̏ꍇ
	else if(m_pTargetTag->m_nTagType == ID_TAG_SINPUT || m_pTargetTag->m_nTagType == ID_TAG_AINPUT || m_pTargetTag->m_nTagType == ID_TAG_PINPUT)
	{
		pIToolView->m_treeInteraction.DeleteItem(pCombInputTag->m_htreeItem);
		pCombInputTag->DeleteCombInputList();
		if(((CXISLCombInputTag*)m_pTargetTag)->DeleteOprItem(pCombInputTag) == FALSE){
				MessageBox("ERROR:COMBDELL-ID_TAG(S*P*A)INPUT\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}

	
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);

}

//o͂̍폜
//2003/5/15@
void CIBFlowView::DeleteOutput(CXISLOutputTag *pOutputTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pOutputTag->m_pParentTag;

	//int nType = pOutputTag->GetOutputType();
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLActItem*)pOutputTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag->DeleteActItem((CXISLActItem*)pOutputTag) == FALSE){
			MessageBox("ERROR:OUTDELL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION ||  m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLActItem*)pOutputTag)->m_htreeItem);
		if(((CXISLActTag*)m_pTargetTag)->DeleteActItem((CXISLActItem*)pOutputTag)== FALSE){
			MessageBox("ERROR:OUTDELL-ID_(OTH*CAL*ACT)\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OPrompt
	else if(m_pTargetTag->m_nTagType == ID_TAG_PROMPT){
		pIToolView->m_treeInteraction.DeleteItem(((CXISLActItem*)pOutputTag)->m_htreeItem);
		((CXISLPrompt*)m_pTargetTag)->m_pXISLAct->DeleteActItem(pOutputTag);
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLActItem*)pOutputTag)->m_htreeItem);
		if(((CXISLBeginEndTag*)m_pTargetTag)->DeleteActItem((CXISLActItem*)pOutputTag)== FALSE){
			MessageBox("ERROR:OUTDELL-ID_BeEn\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OǏo̓^OȂ
	/*else if(m_pTargetTag->m_nTagType == ID_TAG_SOUTPUT || m_pTargetTag->m_nTagType == ID_TAG_AOUTPUT || m_pTargetTag->m_nTagType == ID_POUTPUT)
	{
		`	
	}*/

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Switch^O폜
//2003/5/16@
void CIBFlowView::DeleteSwitch(CXISLSwitchTag *pSwitchTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pSwitchTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == m_pSelectTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLSwitchTag*)pSwitchTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)pSwitchTag->m_pParentTag)->m_pXISLAct;
		if(pActTag->DeleteSwitch((CXISLSwitchTag*)pSwitchTag) == FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	//ȑOɕKvH
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLSwitchTag*)pSwitchTag)->m_htreeItem);
		if(((CXISLActTag*)pSwitchTag->m_pParentTag)->DeleteSwitch((CXISLSwitchTag*)pSwitchTag)== FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_ACT\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLSwitchTag*)pSwitchTag)->m_htreeItem);
		if(((CXISLBeginEndTag*)pSwitchTag->m_pParentTag)->DeleteSwitch((CXISLSwitchTag*)pSwitchTag)== FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_BeEn\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Case^O폜
//2003/5/16@
void CIBFlowView::DeleteCase(CXISLCaseTag *pCaseTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pCaseTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == m_pSelectTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//Case^Oc[r
	pIToolView->m_treeInteraction.DeleteItem(((CXISLActItem*)pCaseTag)->m_htreeItem);
	//Case^OȂɂANV^O
	//((CXISLActTag *)pCaseTag->m_pParentTag)->DeleteItemIntoCase(pCaseTag);
	//Case^O
	if(((CXISLSwitchTag*)pCaseTag->m_pParentTag)->DeleteItemIntoCase(pCaseTag)==FALSE){
		MessageBox("ERROR:CASEDELL-ID_SWITCH\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

// Exit^O̍폜
//2003/5/17/@
void CIBFlowView::DeleteExit(CXISLExitTag *pExitTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pExitTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pExitTag){
		m_pDrawingTag = pExitTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pExitTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLExitTag*)pExitTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)pExitTag->m_pParentTag)->m_pXISLAct;
		pActTag->SetExit(FALSE);
	}
	//e^OActionACaseAOtherȂ
	//ȑOɕKvH
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLExitTag*)pExitTag)->m_htreeItem);
		((CXISLActTag*)m_pTargetTag)->SetExit(FALSE);
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLExitTag*)pExitTag)->m_htreeItem);
		pExitTag = ((CXISLBeginEndTag*)m_pTargetTag)->m_pXISLAct->SetExit(FALSE);
	}
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

// Return^O̍폜
//2003/5/17@
void CIBFlowView::DeleteReturn(CXISLReturnTag *pReturnTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pReturnTag->m_pParentTag;
	
	//int nType = pOutputTag->GetOutputType();
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pReturnTag){
		m_pDrawingTag = pReturnTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pReturnTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLReturnTag*)pReturnTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag->DeleteActItem((CXISLReturnTag*)pReturnTag) == FALSE){
			MessageBox("ERROR:RETURNDELL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLReturnTag*)pReturnTag)->m_htreeItem);
		if(((CXISLActTag*)m_pTargetTag)->DeleteActItem((CXISLReturnTag*)pReturnTag)== FALSE){
			MessageBox("ERROR:RETURNDELL-ID_(OTH*CAL*ACT)\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLReturnTag*)pReturnTag)->m_htreeItem);
		if(((CXISLBeginEndTag*)m_pTargetTag)->DeleteActItem((CXISLReturnTag*)pReturnTag)== FALSE){
			MessageBox("ERROR:RETURNDELL-ID_BeEn\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

// Exchange^O̍폜
//2003/5/19@
void CIBFlowView::DeleteExchange(CXISLExchangeTag *pExchangeTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pExchangeTag->m_pParentTag;

	//int nType = pOutputTag->GetOutputType();
	if(m_pDrawingTag == pExchangeTag){
		m_pDrawingTag = pExchangeTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pExchangeTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLExchangeTag*)pExchangeTag)->m_htreeItem);
		pExchangeTag->DeleteAllOpr();
		pExchangeTag->DeleteAllAct();
		if(((CXISLDialogTag*)m_pTargetTag)->DeleteExchange((CXISLExchangeTag*)pExchangeTag) == FALSE){
			MessageBox("ERROR:EXCHANGEDLL-ID_DIALOG\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	else if(pExchangeTag->m_nTagType == ID_TAG_SEXCHANGE || pExchangeTag->m_nTagType == ID_TAG_PEXCHANGE || pExchangeTag->m_nTagType == ID_TAG_AEXCHANGE){
		pIToolView->m_treeInteraction.DeleteItem(((CXISLExchangeTag*)pExchangeTag)->m_htreeItem);
		pExchangeTag->DeleteAllAct();
		pExchangeTag->DeleteAllOpr();
		pExchangeTag->DeletePromptList();
		((CXISLCombExchangeTag *)m_pTargetTag)->DeleteCombExchange(pExchangeTag);
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Ǐ_CAO̍폜
//2003/6/7@
void CIBFlowView::DeleteCombExchange(CXISLCombExchangeTag *pCExcTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pCExcTag->m_pParentTag;

	//int nType = pOutputTag->GetOutputType();
	if(m_pDrawingTag == pCExcTag){
		m_pDrawingTag = pCExcTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pCExcTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLCombExchangeTag*)pCExcTag)->m_htreeItem);
		pCExcTag->DeleteCombExchangeList();
		((CXISLDialogTag *)m_pTargetTag)->DeleteCombExchange(pCExcTag);

	}
	else if(m_pTargetTag->m_nTagType == ID_TAG_SEXCHANGE || m_pTargetTag->m_nTagType == ID_TAG_PEXCHANGE || m_pTargetTag->m_nTagType == ID_TAG_AEXCHANGE){
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLCombExchangeTag*)pCExcTag)->m_htreeItem);
		pCExcTag->DeleteCombExchangeList();
		((CXISLCombExchangeTag *)m_pTargetTag)->DeleteCombExchange((CXISLExchangeTag *)pCExcTag);
	}
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

// BeginAEnd^O̍폜
//2003/5/20@
void CIBFlowView::DeleteBeginEnd(CXISLBeginEndTag *pBeginEndTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pBeginEndTag->m_pParentTag;

	//int nType = pOutputTag->GetOutputType();
	if(m_pDrawingTag == pBeginEndTag){
		m_pDrawingTag = pBeginEndTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pBeginEndTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//c[Y^O폜
	pIToolView->m_treeInteraction.DeleteItem(((CXISLBeginEndTag*)pBeginEndTag)->m_htreeItem);
	if(m_pTargetTag->m_nTagType == ID_TAG_DIALOG)
	{
		if(pBeginEndTag->m_nTagType == ID_TAG_BEGIN)
			((CXISLDialogTag*)m_pTargetTag)->DestroyBegin();
		else if(pBeginEndTag->m_nTagType == ID_TAG_END)
			((CXISLDialogTag*)m_pTargetTag)->DestroyEnd();
	}

	//e^OǏύX^Ȍꍇ(ȉɎ)
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::DeleteCall(CXISLCallTag *pCallTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pCallTag->m_pParentTag;
	
	//int nType = pOutputTag->GetOutputType();
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pCallTag){
		m_pDrawingTag = pCallTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pCallTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLCallTag*)pCallTag)->m_htreeItem);
		pCallTag->DeleteList();
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag->DeleteActItem((CXISLCallTag*)pCallTag) == FALSE){
			MessageBox("ERROR:CALLDLL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLCallTag*)pCallTag)->m_htreeItem);
		pCallTag->DeleteList();
		if(((CXISLActTag*)m_pTargetTag)->DeleteActItem((CXISLCallTag*)pCallTag)== FALSE){
			MessageBox("ERROR:CALLDLL-ID_(OTH*CAL*ACT)\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLCallTag*)pCallTag)->m_htreeItem);
		pCallTag->DeleteList();
		if(((CXISLBeginEndTag*)m_pTargetTag)->DeleteActItem((CXISLCallTag*)pCallTag)== FALSE){
			MessageBox("ERROR:CALLDLL-ID_BeEnd\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Dialog^O̍폜
//2003/5/21
void CIBFlowView::DeleteDialog(CXISLDialogTag *pDialog)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	CXISLRootTag *pRTag = (CXISLRootTag *)pDialog->GetRootTag();
	
	//int nType = pOutputTag->GetOutputType();
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pDialog){
		m_pDrawingTag = pRTag;//m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pDialog->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	pIToolView->m_treeInteraction.DeleteItem(((CXISLDialogTag*)pDialog)->m_htreeItem);
	pRTag->RemoveDialogTag(((CXISLDialogTag*)pDialog)->GetDialogID());
	if(!((CXISLDialogTag*)pDialog)->m_ReCallList.IsEmpty())
	{
		AfxMessageBox("Ăяołcall,gotöύXĂD",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		CString strDocName;
		CMainFrame *pFrame = (CMainFrame*)AfxGetMainWnd();
		for(int i=0; i<((CXISLDialogTag*)pDialog)->m_ReCallList.GetCount(); i++)
		{
			//Xg擪̃^O擾
			CXISLTag *pTag = (CXISLTag*)(CXISLDialogTag*)pDialog->m_ReCallList.GetHead();
			//擾^Oe_CAO^O擾
			CXISLDialogTag *pDTag = (CXISLDialogTag*)pTag->GetParentDialogTag();
			//^Cg̎擾
			strDocName = pDTag->GetDocName();
//			strDocName.Delete(strDocName.GetLength()-5,5);
			//^Cggq.xisl폜̂Rs[ 2003/4/??@ǉ
			CString strDocNameNoXisl = strDocName.SpanExcluding(".xisl");
			//w肳ꂽ^Cg̃EBhEANeBuɂ
			CIBFlowView *pView = pFrame->SetActiveWnd(strDocNameNoXisl,pTag->m_pParentTag);
			//Call^Õp[^ύX
			((CXISLCallTag*)pTag)->m_pNextDialog = NULL;
			pView->ChangeCallParam((CXISLCallTag*)pTag);
		}
	}
	delete pDialog;
	pDialog=NULL;

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Assign^O̍폜
void CIBFlowView::DeleteAssign(CXISLAssignTag *pAssignTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pAssignTag->m_pParentTag;
	
	//int nType = pOutputTag->GetOutputType();
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pAssignTag){
		m_pDrawingTag = pAssignTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(pAssignTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//e^OExchangeȂ
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLAssignTag*)pAssignTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag->DeleteActItem((CXISLAssignTag*)pAssignTag) == FALSE){
			MessageBox("ERROR:ASSIGNDLL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLAssignTag*)pAssignTag)->m_htreeItem);
		if(((CXISLActTag*)m_pTargetTag)->DeleteActItem((CXISLAssignTag*)pAssignTag)== FALSE){
			MessageBox("ERROR:ASSIGNDLL-ID_(OTH*CAL*ACT)\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLAssignTag*)pAssignTag)->m_htreeItem);
		if(((CXISLBeginEndTag*)m_pTargetTag)->DeleteActItem((CXISLAssignTag*)pAssignTag)== FALSE){
			MessageBox("ERROR:ASSIGNDLL-ID_BeEnd\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::DeleteIf(CXISLIfTag *pIfTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pIfTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == m_pSelectTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLIfTag*)pIfTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)pIfTag->m_pParentTag)->m_pXISLAct;
		if(pActTag->DeleteIf((CXISLIfTag*)pIfTag) == FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	//ȑOɕKvH
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLIfTag*)pIfTag)->m_htreeItem);
		if(((CXISLActTag*)pIfTag->m_pParentTag)->DeleteIf((CXISLIfTag*)pIfTag)== FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_ACT\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OBeginAEndȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_BEGIN || m_pTargetTag->m_nTagType == ID_TAG_END)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLIfTag*)pIfTag)->m_htreeItem);
		if(((CXISLBeginEndTag*)pIfTag->m_pParentTag)->DeleteIf((CXISLIfTag*)pIfTag)== FALSE){
			MessageBox("ERROR:SWITCHDLL-ID_BeEn\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	else if(m_pTargetTag->m_nTagType == ID_TAG_IF || m_pTargetTag->m_nTagType == ID_TAG_ELSEIF){
		pIToolView->m_treeInteraction.DeleteItem(((CXISLIfTag*)pIfTag)->m_htreeItem);
		((CXISLIfTag *)pIfTag->m_pParentTag)->DeleteElseIf();
	}
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

void CIBFlowView::DeleteThenElse(CXISLIfChildTag *pIfCTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pIfCTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == m_pSelectTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);

		m_pSelectTag = NULL;
	}
	//Case^Oc[r
	pIToolView->m_treeInteraction.DeleteItem(((CXISLIfChildTag*)pIfCTag)->m_htreeItem);
	//Case^O
	if(pIfCTag->m_nTagType==ID_TAG_THEN){
		((CXISLIfTag*)pIfCTag->m_pParentTag)->DeleteThen();
	}
	else if(pIfCTag->m_nTagType==ID_TAG_ELSE){
		((CXISLIfTag*)pIfCTag->m_pParentTag)->DeleteElse();
	}

	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Prompt^O폜
//2003/6/6@
void CIBFlowView::DeletePrompt(CXISLPrompt *pPromptTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);

	m_pTargetTag = pPromptTag->m_pParentTag;
	//폜^O擪̃^OȂÕ^Oɖ߂č폜
	if(m_pDrawingTag == pPromptTag){
		m_pDrawingTag = m_pSelectTag->m_pParentTag;
		pIToolView->m_treeInteraction.DeleteItem(m_pSelectTag->m_htreeItem);
		pIToolView->m_bReDrawView = FALSE;
		pIToolView->m_treeInteraction.SelectItem(m_pDrawingTag->m_htreeItem);
		m_pSelectTag = NULL;
	}
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLPrompt*)pPromptTag)->m_htreeItem);
		if(((CXISLExchangeTag*)m_pTargetTag)->DeletePrompt((CXISLPrompt*)pPromptTag) == FALSE){
			MessageBox("ERROR:PROMPTDLL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

//Reprompt^O̍폜
//2003/6/6 
void CIBFlowView::DeleteReprompt(CXISLRepromptTag *pRepromptTag)
{
	CXISLDoc* pDoc = (CXISLDoc*)GetDocument();
	ASSERT(pDoc);
	m_pTargetTag = pRepromptTag->m_pParentTag;
	if(m_pTargetTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		//c[Y^O폜
		pIToolView->m_treeInteraction.DeleteItem(((CXISLRepromptTag*)pRepromptTag)->m_htreeItem);
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)m_pTargetTag)->m_pXISLAct;
		if(pActTag->DeleteActItem((CXISLRepromptTag*)pRepromptTag) == FALSE){
			MessageBox("ERROR:REPROMPTDELL-ID_EXCHANGE\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	//e^OActionACaseAOtherȂ
	else if(m_pTargetTag->m_nTagType == ID_TAG_ACTION || m_pTargetTag->m_nTagType == ID_TAG_CASE || m_pTargetTag->m_nTagType == ID_TAG_OTHER || m_pTargetTag->m_nTagType == ID_TAG_ELSE || m_pTargetTag->m_nTagType == ID_TAG_THEN)
	{
		pIToolView->m_treeInteraction.DeleteItem(((CXISLRepromptTag*)pRepromptTag)->m_htreeItem);
		if(((CXISLActTag*)m_pTargetTag)->DeleteActItem((CXISLRepromptTag*)pRepromptTag)== FALSE){
			MessageBox("ERROR:REPROMPTDELL-ID_(OTH*CAL*ACT)\nȂ炩̖Ń^OێĂ܂","폜ł܂",MB_OK);
		}
	}
	
	ResetViewItem(FALSE);
	pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
}

BOOL CIBFlowView::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pHandlerInfo == NULL )	//@łɊ蓖ĂĂ郁bZ[WȂꍇcc
	{
		//@̕ɂƂŒǉ܂B
		CMenu menu;
		VERIFY(menu.LoadMenu(IDR_TAG_MENU));
		CMenu* pPopup = menu.GetSubMenu(1);
		CWinApp *pApp = AfxGetApp();
		POSITION pos = pApp->GetFirstDocTemplatePosition();
		CXISLDoc *pDoc=NULL;			
		int i=0;
		//݊JĂEBhEEj[ɕ\
		//EBhEI邱ƂŃEBhEԂ̈ړ\
		if( nCode == CN_COMMAND )
		{
		
			//@ebZ[W`FbN܂B
			
			for(i = 0; i < m_XislFileCont; i++ )
			{
				int MenuIndex = IDM_TAB_XISLFILES + i;
				if( nID == (UINT)( MenuIndex ) )//@̃bZ[WȂcc
				{
					/*CCmdUI *pCmdUI = (CCmdUI*)pExtra;
					CMenu *pPopup = pCmdUI->m_pMenu;
					if(pPopup->GetSubMenu(2)!=NULL)return TRUE;*/
					CDocTemplate* pTemplate = pApp->GetNextDocTemplate(pos);
					POSITION tpos = pTemplate->GetFirstDocPosition();
					//hLgwʒu܂ňړ
					for(int dindex=0;dindex<=i;dindex++){
					pDoc = (CXISLDoc *)pTemplate->GetNextDoc(tpos);
					}
					//hLgL΂̃hLg̃EBhEANeBuɂ
					if(pDoc!=NULL){
						CMainFrame *pMFrame = (CMainFrame*)AfxGetMainWnd();
						POSITION pos = pDoc->GetFirstViewPosition();
						CView* pView = pDoc->GetNextView(pos);
						if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
						{
							CFrameWnd *pFrame = pView->GetParentFrame();
							if(pFrame->IsIconic())
								pFrame->ShowWindow(SW_SHOWNORMAL);
							else
								pMFrame->MDIActivate(pFrame);//w肵qEBhEֈړ
							return TRUE;
						}
						return TRUE;
					}
				}
			}
		}
		//COMMANDȂΏCN_UPDATE_COMMAND_UIƔfEEE(GÉE)޲ޮ
		else {
			for(i = 0; i < m_XislFileCont; i++ )
			{
				int MenuIndex = IDM_TAB_XISLFILES + i;
				if( nID == (UINT)( MenuIndex ) )//@̃bZ[WȂcc
				{
					//UIXV
					CCmdUI* pCmdUI = (CCmdUI*)pExtra;
					pCmdUI->Enable( TRUE );
					return TRUE;
				}
			}
		}
	}
	
	return CScrollView::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}